/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.pngwalk.PngWalkTool;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.SinglePngWalkView;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.ImageUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.AlertNullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClickDigitizer {
    PngWalkView view;
    PngWalkTool viewer;
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.pngwalk");

    public ClickDigitizer(PngWalkView view) {
        this.view = view;
    }

    void setViewer(PngWalkTool viewer) {
        this.viewer = viewer;
    }

    private JSONObject getPlotContaining(int height, JSONArray plots, int x, int y) throws JSONException {
        for (int i = 0; i < plots.length(); ++i) {
            double t2;
            JSONObject plot = plots.getJSONObject(i);
            JSONObject yaxis = plot.getJSONObject("yaxis");
            double t1 = yaxis.optDouble("top", -9999.0);
            if (t1 == -9999.0) {
                t1 = (double)height - yaxis.optDouble("upper");
            }
            if ((t2 = yaxis.optDouble("bottom", -9999.0)) == -9999.0) {
                t2 = (double)height - yaxis.optDouble("lower");
            }
            if (t1 > t2) {
                double t = t2;
                t2 = t1;
                t1 = t;
            }
            if (!(t1 <= (double)y) || !((double)y < t2)) continue;
            JSONObject xaxis = plot.getJSONObject("xaxis");
            t1 = xaxis.getInt("left");
            if (t1 > (t2 = (double)xaxis.getInt("right"))) {
                t2 = yaxis.getInt("left");
                t1 = yaxis.getInt("right");
            }
            if (!(t1 <= (double)x) || !((double)x < t2)) continue;
            return plot;
        }
        return null;
    }

    private QDataSet invTransform(JSONObject axis, int p, String smaller, String bigger) throws JSONException, ParseException {
        Datum result;
        DatumRange rr;
        DatumRange range;
        boolean log = axis.optString("type", "lin").equals("log");
        boolean flipped = axis.optString("flipped", "false").equals("true");
        if ("UTC".equals(axis.optString("units", ""))) {
            range = DatumRangeUtil.parseISO8601Range((String)(axis.getString("min") + "/" + axis.getString("max")));
        } else {
            String sunits = axis.optString("units", "");
            Units units = Units.lookupUnits((String)sunits);
            range = new DatumRange(units.parse(axis.getString("min")), units.parse(axis.getString("max")));
        }
        double nn = ((double)p + 0.5 - (double)axis.getInt(smaller)) / (double)(axis.getInt(bigger) - axis.getInt(smaller));
        if (flipped) {
            nn = 1.0 - nn;
        }
        if (log) {
            rr = DatumRangeUtil.rescaleLog((DatumRange)range, (double)nn, (double)nn);
            result = rr.min();
        } else {
            rr = DatumRangeUtil.rescale((DatumRange)range, (double)nn, (double)nn);
            result = rr.min();
        }
        DRank0DataSet r = DataSetUtil.asDataSet((Datum)result);
        r = Ops.putProperty((QDataSet)r, (String)"LABEL", (Object)axis.optString("label", ""));
        r = Ops.putProperty((QDataSet)r, (String)"SCALE_TYPE", (Object)(log ? "log" : "linear"));
        return r;
    }

    private int transform1D(JSONObject axis, Datum datum, String smaller, String bigger) throws JSONException, ParseException {
        DatumRange range;
        boolean log = axis.get("type").equals("log");
        if ("UTC".equals(axis.getString("units"))) {
            range = DatumRangeUtil.parseISO8601Range((String)(axis.getString("min") + "/" + axis.getString("max")));
        } else {
            String sunits = axis.getString("units");
            Units units = Units.lookupUnits((String)sunits);
            range = new DatumRange(units.parse(axis.getString("min")), units.parse(axis.getString("max")));
        }
        if (range.getUnits().isConvertibleTo(datum.getUnits())) {
            double d = log ? DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)datum) : DatumRangeUtil.normalize((DatumRange)range, (Datum)datum);
            int result = (int)((double)axis.getInt(smaller) + d * (double)(axis.getInt(bigger) - axis.getInt(smaller)));
            if (result < -10000) {
                result = -10000;
            } else if (result > 10000) {
                result = 10000;
            }
            return result;
        }
        return axis.getInt(smaller);
    }

    protected void doLookupMetadata(int x, int y) throws IOException, ParseException {
        this.doLookupMetadata(x, y, false);
    }

    protected void doLookupMetadata(int x, int y, boolean release) throws IOException, ParseException {
        block18: {
            URI uri = this.view.seq.imageAt(this.view.seq.getIndex()).getUri();
            File file = DataSetURI.getFile((URI)uri, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
            String json = ImageUtil.getJSONMetadata((File)file);
            HashMap<String, String> meta = new HashMap<String, String>();
            meta.put("image", this.view.seq.getSelectedName());
            if (json != null) {
                try {
                    JSONObject jo = new JSONObject(json);
                    JSONArray size = jo.optJSONArray("size");
                    if (size == null) {
                        this.view.seq.setStatus("RichPNG is missing size.");
                        return;
                    }
                    JSONArray plots = jo.getJSONArray("plots");
                    JSONObject plot = this.getPlotContaining(size.getInt(1), plots, x, y);
                    if (plot == null) break block18;
                    JSONObject xaxis = plot.getJSONObject("xaxis");
                    QDataSet xx = this.invTransform(xaxis, x, "left", "right");
                    JSONObject yaxis = plot.getJSONObject("yaxis");
                    if (yaxis.has("lower") && size != null) {
                        int h = size.getInt(1);
                        yaxis.put("bottom", (double)h - yaxis.getDouble("lower"));
                        yaxis.put("top", (double)h - yaxis.getDouble("upper"));
                    }
                    QDataSet yy = this.invTransform(yaxis, y, "bottom", "top");
                    if (this.viewer != null) {
                        this.view.seq.setStatus("Plot Coordinates: " + xx + ", " + yy);
                        if (this.viewer.digitizer != null && UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)xx))) {
                            this.viewer.digitizer.setSorted(true);
                        }
                        if (!release && this.viewer.digitizer != null && this.viewer.digitizerRecording) {
                            try {
                                this.viewer.digitizer.addDataPoint(DataSetUtil.asDatum((QDataSet)xx), DataSetUtil.asDatum((QDataSet)yy), meta);
                            }
                            catch (RuntimeException ex) {
                                String msg = DataSourceUtil.getMessage((Exception)ex);
                                JOptionPane.showMessageDialog(this.viewer, msg);
                            }
                        }
                        QDataSet q = Ops.bundle((QDataSet)xx, (QDataSet)yy);
                        if (release) {
                            this.viewer.firePropertyChange("mouseReleaseLocation", null, q);
                        } else {
                            this.viewer.firePropertyChange("mousePressLocation", null, q);
                        }
                        break block18;
                    }
                    this.view.seq.setStatus("Plot Coordinates: " + xx + ", " + yy + "  (Options->Start Digitizer to record)");
                }
                catch (JSONException ex) {
                    Logger.getLogger(SinglePngWalkView.class.getName()).log(Level.SEVERE, null, ex);
                    int h = this.view.seq.imageAt(this.view.seq.getIndex()).getImage().getHeight();
                    Datum xx = Units.dimensionless.createDatum(x);
                    Datum yy = Units.dimensionless.createDatum(h - y);
                    this.view.seq.setStatus("Pixel Coordinates: " + xx + ", " + yy + " (unable to use JSON) ");
                }
            } else {
                int h = this.view.seq.imageAt(this.view.seq.getIndex()).getImage().getHeight();
                Datum xx = Units.dimensionless.createDatum(x);
                Datum yy = Units.dimensionless.createDatum(h - y);
                if (this.viewer != null) {
                    this.view.seq.setStatus("Pixel Coordinates: " + xx + ", " + yy);
                    if (!release && this.viewer.digitizer != null) {
                        try {
                            this.viewer.digitizer.setSorted(false);
                            this.viewer.digitizer.addDataPoint(xx, yy, meta);
                        }
                        catch (RuntimeException ex) {
                            JOptionPane.showMessageDialog(this.viewer, ex.getMessage());
                        }
                    }
                } else {
                    this.view.seq.setStatus("Pixel Coordinates: " + xx + ", " + yy + "  (Options->Start Digitizer to record)");
                }
            }
        }
    }

    public QDataSet pixelToDataTransform(int x, int y) throws IOException, ParseException {
        if (this.view == null) {
            throw new IllegalArgumentException("view is not attached");
        }
        URI uri = this.view.seq.imageAt(this.view.seq.getIndex()).getUri();
        File file = DataSetURI.getFile((URI)uri, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
        String json = ImageUtil.getJSONMetadata((File)file);
        return this.doTransformPoint(json, -1, x, y);
    }

    public QDataSet pixelToDataTransform(int iplot, int x, int y) throws IOException, ParseException {
        if (this.view == null) {
            throw new IllegalArgumentException("view is not attached");
        }
        URI uri = this.view.seq.imageAt(this.view.seq.getIndex()).getUri();
        File file = DataSetURI.getFile((URI)uri, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
        String json = ImageUtil.getJSONMetadata((File)file);
        return this.doTransformPoint(json, iplot, x, y);
    }

    public int[] dataToPixelTransform(int iplot, QDataSet p) throws IOException, ParseException {
        if (this.view == null) {
            throw new IllegalArgumentException("view is not attached");
        }
        URI uri = this.view.seq.imageAt(this.view.seq.getIndex()).getUri();
        File file = DataSetURI.getFile((URI)uri, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
        String json = ImageUtil.getJSONMetadata((File)file);
        return this.doInvTransformPoint(json, iplot, p);
    }

    private QDataSet doTransformPoint(String json, int iplot, int x, int y) throws IOException, ParseException {
        if (json != null) {
            try {
                JSONObject plot;
                JSONObject jo = new JSONObject(json);
                JSONArray plots = jo.getJSONArray("plots");
                if (iplot == -1) {
                    JSONArray size = jo.getJSONArray("size");
                    plot = this.getPlotContaining(size.getInt(1), plots, x, y);
                } else {
                    plot = plots.getJSONObject(iplot);
                }
                if (plot != null) {
                    JSONObject xaxis = plot.getJSONObject("xaxis");
                    QDataSet xx = this.invTransform(xaxis, x, "left", "right");
                    JSONObject yaxis = plot.getJSONObject("yaxis");
                    QDataSet yy = this.invTransform(yaxis, y, "bottom", "top");
                    QDataSet result = Ops.bundle((QDataSet)xx, (QDataSet)yy);
                    for (int i = 0; i < plots.length(); ++i) {
                        if (plots.getJSONObject(i) != plot) continue;
                        result = Ops.putProperty((QDataSet)result, (String)"PlotNumber", (Object)i);
                    }
                    return result;
                }
                WritableDataSet result = Ops.replicate((double)Double.NaN, (int)2);
                result = Ops.putProperty((QDataSet)result, (String)"PlotNumber", (Object)-1);
                return result;
            }
            catch (JSONException ex) {
                Logger.getLogger(SinglePngWalkView.class.getName()).log(Level.SEVERE, null, ex);
                int h = this.view.seq.imageAt(this.view.seq.getIndex()).getImage().getHeight();
                Datum xx = Units.dimensionless.createDatum(x);
                Datum yy = Units.dimensionless.createDatum(h - y);
                QDataSet result = Ops.bundle((QDataSet)Ops.dataset((Object)xx), (QDataSet)Ops.dataset((Object)yy));
                result = Ops.putProperty((QDataSet)result, (String)"PlotNumber", (Object)-1);
                return result;
            }
        }
        int h = this.view.seq.imageAt(this.view.seq.getIndex()).getImage().getHeight();
        Datum xx = Units.dimensionless.createDatum(x);
        Datum yy = Units.dimensionless.createDatum(h - y);
        QDataSet result = Ops.bundle((QDataSet)Ops.dataset((Object)xx), (QDataSet)Ops.dataset((Object)yy));
        result = Ops.putProperty((QDataSet)result, (String)"PlotNumber", (Object)-99);
        return result;
    }

    private int[] doInvTransformPoint(String json, int iplot, QDataSet ds) throws IOException, ParseException {
        if (json != null) {
            try {
                JSONObject jo = new JSONObject(json);
                JSONArray plots = jo.getJSONArray("plots");
                Object o = ds.property("PlotNumber");
                JSONObject plot = plots.getJSONObject(iplot);
                if (plot != null) {
                    JSONObject xaxis = plot.getJSONObject("xaxis");
                    int ii = this.transform1D(xaxis, Ops.datum((Object)ds.slice(0)), "left", "right");
                    JSONObject yaxis = plot.getJSONObject("yaxis");
                    int jj = this.transform1D(yaxis, Ops.datum((Object)ds.slice(1)), "bottom", "top");
                    return new int[]{ii, jj};
                }
                return null;
            }
            catch (JSONException ex) {
                Logger.getLogger(SinglePngWalkView.class.getName()).log(Level.SEVERE, null, ex);
                int h = this.view.seq.imageAt(this.view.seq.getIndex()).getImage().getHeight();
                Datum xx = Units.dimensionless.createDatum(ds.value(0));
                Datum yy = Units.dimensionless.createDatum((double)h - ds.value(1));
                return new int[]{(int)xx.value(), (int)yy.value()};
            }
        }
        int h = this.view.seq.imageAt(this.view.seq.getIndex()).getImage().getHeight();
        Datum xx = Units.dimensionless.createDatum(ds.value(0));
        Datum yy = Units.dimensionless.createDatum((double)h - ds.value(1));
        return new int[]{(int)xx.value(), (int)yy.value()};
    }

    protected QDataSet doTransform() throws IOException {
        QDataSet dep0;
        URI uri = this.view.seq.imageAt(this.view.seq.getIndex()).getUri();
        File file = DataSetURI.getFile((URI)uri, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
        String json = ImageUtil.getJSONMetadata((File)file);
        QDataSet ds = this.viewer.digitizer.getDataSet();
        if (ds == null) {
            return null;
        }
        if (ds.length() == 0) {
            return null;
        }
        if (ds.rank() > 1) {
            EnumerationUnits eu;
            QDataSet images = Ops.slice1((QDataSet)ds, (int)1);
            QDataSet r = Ops.where((QDataSet)Ops.eq((Object)images, (Object)(eu = (EnumerationUnits)SemanticOps.getUnits((QDataSet)images)).createDatum((Object)this.view.seq.getSelectedName())));
            if (r.length() == 0) {
                return null;
            }
            ds = DataSetOps.applyIndex((QDataSet)ds, (int)0, (QDataSet)r, (boolean)true);
            ds = Ops.slice1((QDataSet)ds, (int)0);
        }
        if ((dep0 = (QDataSet)ds.property("DEPEND_0")).rank() > 1) {
            dep0 = dep0.slice(0);
        }
        if (json == null) {
            BufferedImage im = this.view.seq.imageAt(this.view.seq.getIndex()).getImageIfLoaded();
            if (im == null) {
                return null;
            }
            return Ops.bundle((QDataSet)dep0, (QDataSet)Ops.subtract((QDataSet)Ops.dataset((Object)im.getHeight()), (QDataSet)ds));
        }
        QDataSet result = null;
        for (int ii = 0; ii < ds.length(); ++ii) {
            Datum x = DataSetUtil.asDatum((QDataSet)dep0.slice(ii));
            Datum y = DataSetUtil.asDatum((QDataSet)ds.slice(ii));
            try {
                JSONObject jo = new JSONObject(json);
                JSONArray plots = jo.getJSONArray("plots");
                for (int i = 0; i < plots.length(); ++i) {
                    JSONObject plot = plots.getJSONObject(i);
                    JSONObject xaxis = plot.getJSONObject("xaxis");
                    JSONObject yaxis = plot.getJSONObject("yaxis");
                    int ix = this.transform1D(xaxis, x, "left", "right");
                    int iy = this.transform1D(yaxis, y, "bottom", "top");
                    if (ix == Integer.MAX_VALUE || iy == Integer.MAX_VALUE) continue;
                    result = Ops.join(result, (QDataSet)Ops.join((QDataSet)DataSetUtil.asDataSet((double)ix), (QDataSet)DataSetUtil.asDataSet((double)iy)));
                }
                continue;
            }
            catch (ParseException | JSONException ex) {
                logger.log(Level.SEVERE, "error parsing rich png JSON metadata", ex);
            }
        }
        return result;
    }

    protected int maybeSelect(Point p) throws IOException, ParseException {
        if (this.viewer == null || this.viewer.digitizer == null) {
            return -1;
        }
        URI uri = this.view.seq.imageAt(this.view.seq.getIndex()).getUri();
        File file = DataSetURI.getFile((URI)uri, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
        String json = ImageUtil.getJSONMetadata((File)file);
        QDataSet ds1 = this.doTransformPoint(json, -1, p.x - 2, p.y - 2);
        QDataSet ds2 = this.doTransformPoint(json, -1, p.x + 2, p.y + 2);
        if (ds1 == null) {
            return -1;
        }
        DatumRange xrange = DatumRangeUtil.union((Datum)DataSetUtil.asDatum((QDataSet)ds1.slice(0)), (Datum)DataSetUtil.asDatum((QDataSet)ds2.slice(0)));
        DatumRange yrange = DatumRangeUtil.union((Datum)DataSetUtil.asDatum((QDataSet)ds1.slice(1)), (Datum)DataSetUtil.asDatum((QDataSet)ds2.slice(1)));
        if (!UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)ds2))) {
            return -1;
        }
        if (this.viewer.digitizer != null) {
            int isel;
            switch (this.viewer.annoTypeChar) {
                case '.': {
                    isel = this.viewer.digitizer.select(xrange, yrange);
                    break;
                }
                case '+': {
                    isel = this.viewer.digitizer.select(xrange, yrange, true);
                    break;
                }
                case '|': {
                    isel = this.viewer.digitizer.select(xrange, null);
                    break;
                }
                default: {
                    throw new RuntimeException("can't find annoTypeChar");
                }
            }
            return isel;
        }
        return -1;
    }
}

